import math


def is_prime(num):
    """Проверяет, является ли число простым."""
    if num <= 1:
        return False
    for i in range(2, int(math.isqrt(num)) + 1):
        if num % i == 0:
            return False
    return True


def prime_factors_count(n):
    """Возвращает список пар (простое число, степень)."""
    factors = []
    count = 0

    # Деление на двойку отдельно, чтобы упростить дальнейшую работу
    while n % 2 == 0:
        count += 1
        n //= 2
    if count > 0:
        factors.append((2, count))

    # Теперь работаем с остальными простыми числами
    for i in range(3, int(math.isqrt(n)) + 1, 2):
        count = 0
        while n % i == 0:
            count += 1
            n //= i
        if count > 0:
            factors.append((i, count))

    if n > 1:
        factors.append((n, 1))

    return factors


def is_odd_powered(n):
    """Определяет, является ли число нечётно-степенным."""
    factors = prime_factors_count(n)
    for _, exp in factors:
        if exp % 2 == 0:
            return False
    return True


# Читаем входные данные
m = int(input())
l, r = map(int, input().split())

found_sequence = None

for start in range(l, r - m + 2):  # Ищем первое возможное число начала последовательности
    valid = True
    sequence = []
    for j in range(start, start + m):
        if not is_odd_powered(j):
            valid = False
            break
        else:
            sequence.append(j)
    if valid:
        found_sequence = sequence
        break

if found_sequence:
    print(" ".join(map(str, found_sequence)))
else:
    print(-1)
