import sys
import math


def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return

    m = int(data[0])
    l = int(data[1])
    r = int(data[2])

    # Массив для отметки нечётно-степенных чисел
    # is_valid[i] = True, если i - нечётно-степенное
    n = r
    is_valid = [True] * (n + 1)
    is_valid[0] = False

    # Решето: отмечаем числа, которые делятся на квадрат простого числа
    for i in range(2, int(math.sqrt(n)) + 1):
        if i * i > n:
            break
        square = i * i
        for j in range(square, n + 1, square):
            is_valid[j] = False

    # Теперь is_valid[i] = True для бесквадратных чисел
    # Бесквадратное число = все простые делители в степени 1
    # Это частный случай нечётно-степенного числа

    # Но нам нужно учитывать числа вида p^3, p^5 и т.д.
    # Для этого: если число делится на p^2, оно уже отмечено как False
    # Остаются числа, где все простые в нечётной степени

    # Ищем последовательность длины m
    count = 0
    start = -1

    for num in range(l, r + 1):
        if is_valid[num]:
            count += 1
            if count == m:
                start = num - m + 1
                break
        else:
            count = 0

    if start == -1:
        print(-1)
    else:
        result = ' '.join(str(start + i) for i in range(m))
        print(result)


if __name__ == "__main__":
    solve()
