import sys


def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return

    m = int(data[0])
    l = int(data[1])
    r = int(data[2])

    # Максимальное число, с которым будем работать
    max_num = r

    # Создадим массив для хранения "степени нечётности" чисел
    # Для нечётно-степенного числа все простые делители должны быть в нечётной степени
    # Это эквивалентно тому, что число является произведением простых чисел в нечётных степенях
    # Или что число является бесквадратным (square-free) умножить на полный квадрат

    # Более простой подход: для каждого числа проверим, является ли оно нечётно-степенным
    # Можно использовать решето для факторизации

    # Массив для хранения информации о числах
    # Будем хранить для каждого числа произведение простых делителей в первой степени
    # Если при обработке встретим квадрат простого числа, помечаем число как не подходящее

    is_odd_power = [True] * (max_num + 1)

    # 0 и 1 не являются натуральными для нашей задачи, но для индексации
    is_odd_power[0] = False
    if max_num >= 1:
        is_odd_power[1] = True  # 1 подходит (пустое произведение)

    # Решето Эратосфена с проверкой на квадраты простых чисел
    for i in range(2, max_num + 1):
        if i * i > max_num:
            break

        if is_odd_power[i]:
            # i - простое число
            # Отметим все числа, содержащие i^2
            square = i * i
            for j in range(square, max_num + 1, square):
                is_odd_power[j] = False

    # Теперь is_odd_power[i] = True, если i не содержит квадратов простых чисел
    # Но нам нужно проверить нечётные степени:
    # число должно быть бесквадратным (не иметь квадратов простых делителей)
    # Это уже сделано выше

    # Находим первую последовательность из m подряд идущих нечётно-степенных чисел
    count = 0
    start = -1

    for num in range(l, r + 1):
        if is_odd_power[num]:
            count += 1
            if count == 1:
                current_start = num
            if count == m:
                start = current_start
                break
        else:
            count = 0

    if start == -1:
        print(-1)
    else:
        # Выводим m чисел, начиная с start
        result = []
        for i in range(m):
            result.append(str(start + i))
        print(" ".join(result))


if __name__ == "__main__":
    solve()
