def sieve_primes(limit):
    """Возвращает список простых чисел до limit."""
    is_prime = [True] * (limit + 1)
    is_prime[0] = is_prime[1] = False
    for i in range(2, int(limit ** 0.5) + 1):
        if is_prime[i]:
            step = i
            start = i * i
            is_prime[start:limit + 1:step] = [False] * ((limit - start) // step + 1)
    return [i for i, p in enumerate(is_prime) if p]


def main():
    m = int(input())
    l, r = map(int, input().split())

    # Создаем массив для отметок нечётно-степенных чисел
    n = r - l + 1
    arr = [True] * n  # Изначально считаем все числа подходящими

    # Простые числа до r
    primes = sieve_primes(r)

    # Для каждого простого числа p
    for p in primes:
        if p > r:
            break

        # Находим первое число >= l, которое делится на p^2
        start = ((l + p * p - 1) // (p * p)) * (p * p)

        # Отмечаем все числа, которые делятся на p^2, p^4, ... как неподходящие
        # (так как содержат простой множитель p в четной степени)
        power = p * p
        while power <= r:
            # Для каждого числа, делящегося на power^2? Нет, нужно mark числа,
            # которые делятся на p^(2k) для k >= 1, то есть на p^2, p^4, p^6, ...
            # Но проще: если число делится на p^2, то степень p в его разложении как минимум 2,
            # и если степень четная >= 2, то число не подходит.
            # Однако если степень p = 2, то четная, не подходит.
            # Если степень p = 3, то нечетная, подходит.
            # Значит, нужно помечать числа, у которых степень p четная.
            # Это числа, делящиеся на p^(2k) для k>=1.

            # Так как r <= 10^6, идем по степеням p^2, p^4, ...
            current = start
            while current <= r:
                idx = current - l
                if 0 <= idx < n:
                    arr[idx] = False
                current += power * power  # переходим к следующему числу, делящемуся на следующую четную степень?
            power *= p * p  # переходим к p^4, p^6, ...

    # Теперь ищем последовательность из m подряд идущих True в arr
    count = 0
    for i in range(n):
        if arr[i]:
            count += 1
            if count >= m:
                # Нашли последовательность длины >= m
                start_idx = i - m + 1
                result = list(range(l + start_idx, l + start_idx + m))
                print(' '.join(map(str, result)))
                return
        else:
            count = 0

    print(-1)


if __name__ == "__main__":
    main()
