def count_magic_up_to(N):
    """Количество магических чисел от 1 до N включительно."""
    if N < 7:
        return 0

    div7 = N // 7
    ends_with_7 = (N - 7) // 10 + 1
    both = (N - 7) // 70 + 1

    return div7 + ends_with_7 - both


def find_kth_magic_number(k):
    """Находит k-е магическое число с помощью бинарного поиска."""
    left, right = 1, 10 ** 19  # Верхняя граница заведомо большая

    while left < right:
        mid = (left + right) // 2
        if count_magic_up_to(mid) >= k:
            right = mid
        else:
            left = mid + 1

    return left


def main():
    k = int(input().strip())
    result = find_kth_magic_number(k)
    print(result)


if __name__ == "__main__":
    main()
