import sys


def count_cells_for_color(n, m, k, r):
    """Считает количество клеток для цвета, соответствующего остатку r (0 ≤ r < k)."""
    total = 0
    # s = i+j, s от 2 до n+m
    # s должно быть ≡ r+2 (mod k) => s = 2 + r + t*k

    # Найдем все допустимые t
    t_min = 0
    t_max = (n + m - 2 - r) // k

    # Вместо перебора всех t, используем тот факт, что
    # количество клеток для данного s = max(0, min(n, s-1) - max(1, s-m) + 1)
    # Это функция от s, которая линейна на участках

    # Найдем участки, где функция линейна
    # 1) s ≤ min(n, m)+1: count = s-1
    # 2) min(n, m)+1 < s ≤ max(n, m)+1: count = min(n, m)
    # 3) s > max(n, m)+1: count = n+m-s+1

    a = min(n, m)
    b = max(n, m)

    # Участок 1: s от 2 до a+1
    # Максимальный t для этого участка: t1_max = (a-1-r)//k
    t1_max = (a - 1 - r) // k
    if t1_max >= 0:
        cnt = t1_max + 1
        # sum(s-1) = sum(1+r + t*k) для t=0..t1_max
        first = 1 + r
        last = 1 + r + t1_max * k
        total += cnt * (first + last) // 2

    # Участок 2: s от a+1 до b+1
    t2_min = max(0, (a - 1 - r + k) // k)  # ceil((a-1-r)/k)
    t2_max = (b - 1 - r) // k
    if t2_min <= t2_max:
        cnt_t = t2_max - t2_min + 1
        total += cnt_t * a

    # Участок 3: s от b+1 до n+m
    t3_min = max(0, (b - 1 - r + k) // k)  # ceil((b-1-r)/k)
    t3_max = (n + m - 2 - r) // k
    if t3_min <= t3_max:
        cnt_t = t3_max - t3_min + 1
        # sum(n+m-s+1) = sum(n+m-1-r - t*k)
        sum_t = (t3_min + t3_max) * cnt_t // 2
        total += cnt_t * (n + m - 1 - r) - k * sum_t

    return total


def main():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n, m, k = map(int, data)

    ans = []
    for r in range(k):
        ans.append(count_cells_for_color(n, m, k, r))

    sys.stdout.write("\n".join(map(str, ans)))


if __name__ == "__main__":
    main()
