n = int(input())
m = int(input())
k = int(input())

# Массив для подсчёта количества клеток каждого цвета (индексация с 0)
colors = [0] * k

# Перебираем все возможные суммы индексов (i + j), которые определяют диагонали
for s in range(2, n + m + 1):
    # Определяем допустимые границы для строки i
    i_min = max(1, s - m)  # чтобы столбец j = s - i не выходил за границы
    i_max = min(n, s - 1)  # чтобы строка i не выходила за границы

    # Количество клеток на текущей диагонали
    cell_count = i_max - i_min + 1

    # Определяем индекс цвета (циклически через k цветов)
    color_idx = (s - 2) % k

    # Добавляем количество клеток к соответствующему цвету
    colors[color_idx] += cell_count

# Выводим результат: количество клеток для каждого цвета (по одному числу в строке)
for count in colors:
    print(count)
