n = int(input())
m = int(input())
k = int(input())

# Массив для подсчёта количества клеток каждого цвета (индексация с 0)
colors = [0] * k

# Общая идея: клетки на одной диагонали имеют одинаковую сумму индексов (i + j)
# Первая диагональ (сумма = 2): (1,1)
# Вторая диагональ (сумма = 3): (1,2), (2,1)
# И т. д.

# Минимальная и максимальная сумма индексов в сетке
min_sum = 2
max_sum = n + m

for s in range(min_sum, max_sum + 1):
    # Определяем границы для i (строки)
    i_min = max(1, s - m)
    i_max = min(n, s - 1)

    # Количество клеток на диагонали с суммой s
    count = i_max - i_min + 1

    # Номер цвета (с учётом циклического повторения через k цветов)
    color_index = (s - 2) % k

    colors[color_index] += count

# Выводим результат — количество клеток для каждого цвета
for c in colors:
    print(c)
