def solve():
    n, m, k = map(int, input().split())
    result = [0] * k
    
    a = min(n, m)
    b = max(n, m)
    
    for color in range(k):
        total = 0
        
        # Участок I: s от 2 до a+1, f(s) = s-1
        # s = 2 + color + t*k, где t >= 0
        # s <= a+1 => t <= (a-1-color)//k
        
        t1_max = (a - 1 - color) // k
        if t1_max >= 0:
            # Сумма (s-1) = сумма (1 + color + t*k)
            # Количество элементов: t1_max + 1
            # Сумма арифметической прогрессии:
            first = 1 + color  # при t=0
            last = 1 + color + t1_max * k
            count = t1_max + 1
            total += count * (first + last) // 2
        
        # Участок II: s от a+1 до b+1, f(s) = a
        # s = 2 + color + t*k
        # a+1 <= s <= b+1
        
        # t_min = ceil((a+1 - 2 - color)/k) = ceil((a-1-color)/k)
        # t_max = floor((b+1 - 2 - color)/k) = floor((b-1-color)/k)
        
        t2_min = max(0, (a - 1 - color + k) // k)
        t2_max = (b - 1 - color) // k
        
        if t2_min <= t2_max:
            count = t2_max - t2_min + 1
            total += count * a
        
        # Участок III: s от b+1 до n+m, f(s) = n+m-s+1
        # s = 2 + color + t*k
        # n+m-s+1 = n+m+1 - s = n+m+1 - (2+color+t*k) = n+m-1-color - t*k
        
        t3_min = max(0, (b - 1 - color + k) // k)
        t3_max = (n + m - 2 - color) // k
        
        if t3_min <= t3_max:
            # Сумма (n+m-1-color - t*k) по t от t3_min до t3_max
            # = сумма_констант - k*сумма_t
            count = t3_max - t3_min + 1
            const_sum = count * (n + m - 1 - color)
            t_sum = count * (t3_min + t3_max) // 2 * k
            total += const_sum - t_sum
        
        result[color] = total
    
    print('\n'.join(map(str, result)))

if __name__ == "__main__":
    solve()
