def solve():
    n, m, k = map(int, input().split())
    result = [0] * k

    # Для каждой возможной суммы индексов (i+j)
    # Цвет определяется как (i+j-2) % k
    # Но нам не нужно перебирать все клетки из-за больших n и m

    # Минимальная сумма индексов: 2 (1+1)
    # Максимальная сумма индексов: n+m

    for total in range(2, n + m + 1):
        # Определяем цвет для этой диагонали
        color = (total - 2) % k

        # Количество клеток на этой диагонали:
        # Клетки удовлетворяют условиям:
        # 1 <= i <= n, 1 <= j <= m, i + j = total

        # Минимальное i: max(1, total - m)
        # Максимальное i: min(n, total - 1)

        min_i = max(1, total - m)
        max_i = min(n, total - 1)

        count = max(0, max_i - min_i + 1)
        result[color] += count

    # Выводим результат
    print('\n'.join(map(str, result)))


if __name__ == "__main__":
    solve()
