def solve():
    n, m, k = map(int, input().split())
    # Гарантируем n <= m для удобства
    if n > m:
        n, m = m, n

    # Результат для цветов 1..k
    result = [0] * k

    # Для каждого остатка r = 0..k-1 (соответствует цвету r+1)
    for r in range(k):
        # Нам нужны S ≡ r+2 (mod k)
        c = (r + 2) % k

        # Фаза 1: S от 2 до n+1, count(S) = S-1
        # Находим первое S >= 2 с остатком c mod k
        start1 = c
        if start1 < 2:
            start1 += k
        # Если start1 > n+1, то в этой фазе нет S
        if start1 <= n + 1:
            # Последнее S в диапазоне с таким остатком
            last1 = n + 1 - ((n + 1 - start1) % k)
            # Количество членов арифметической прогрессии
            cnt1 = (last1 - start1) // k + 1
            # Сумма count(S) = S-1 для этих S
            # Сумма S = сумма арифметической прогрессии start1, start1+k, ..., last1
            sum_S = (start1 + last1) * cnt1 // 2
            # Сумма (S-1) = sum_S - cnt1
            result[r] += sum_S - cnt1

        # Фаза 2: S от n+2 до m+1, count(S) = n
        start2 = c
        # Подгоняем под диапазон [n+2, m+1]
        # Первое S >= n+2 с остатком c
        start2 = n + 2
        remainder = (start2 - c) % k
        if remainder != 0:
            start2 += (k - remainder)
        if start2 <= m + 1:
            last2 = m + 1 - ((m + 1 - start2) % k)
            cnt2 = (last2 - start2) // k + 1
            result[r] += n * cnt2

        # Фаза 3: S от m+2 до n+m, count(S) = n+m-S+1
        start3 = c
        # Первое S >= m+2 с остатком c
        start3 = m + 2
        remainder = (start3 - c) % k
        if remainder != 0:
            start3 += (k - remainder)
        if start3 <= n + m:
            last3 = n + m - ((n + m - start3) % k)
            cnt3 = (last3 - start3) // k + 1
            # Сумма count(S) = сумма (n+m+1) - сумма S
            result[r] += (n + m + 1) * cnt3 - ((start3 + last3) * cnt3 // 2)

    # Вывод результата
    print(' '.join(map(str, result)))


if __name__ == "__main__":
    solve()
