def can_shine_all_rooms(rectangles):
    # Вершины всех прямоугольников (верхняя-правая и нижняя-левая)
    points = []
    for rect in rectangles:
        x1, y1, x2, y2 = rect
        points.append((x1, y1))  # Левый нижний угол
        points.append((x2, y2))  # Правый верхний угол

    # Проверка пересечения всех прямоугольников по оси Y
    lower_y = float('-inf')
    upper_y = float('inf')
    for point in points:
        x, y = point
        lower_y = max(lower_y, y)
        upper_y = min(upper_y, y)

    # Если все прямоугольники пересекаются по оси Y, то возможен луч
    if lower_y <= upper_y:
        return True

    # Аналогично проверяем по оси X
    left_x = float('-inf')
    right_x = float('inf')
    for point in points:
        x, y = point
        left_x = max(left_x, x)
        right_x = min(right_x, x)

    # Если все прямоугольники пересекаются по оси X, то возможен луч
    if left_x <= right_x:
        return True

    return False


T = int(input())  # Число тестов
for _ in range(T):
    n = int(input())  # Количество прямоугольников
    rectangles = []  # Список прямоугольников
    for _ in range(n):
        rectangle = tuple(map(int, input().split()))  # Координаты прямоугольника
        rectangles.append(rectangle)

    if can_shine_all_rooms(rectangles):
        print("Yes")
    else:
        print("No")