from math import isqrt


def prime_factors(n):
    """Возвращает словарь {простое число : его степень}"""
    factors = {}
    while n % 2 == 0:
        factors[2] = factors.get(2, 0) + 1
        n //= 2
    for i in range(3, isqrt(n) + 1, 2):
        while n % i == 0:
            factors[i] = factors.get(i, 0) + 1
            n //= i
    if n > 1:
        factors[n] = factors.get(n, 0) + 1
    return factors


def is_odd_powered(n):
    """Проверяет, является ли число нечётно-степенным."""
    factors = prime_factors(n)
    for exp in factors.values():
        if exp % 2 == 0:
            return False
    return True


def find_sequence(l, r, m):
    current_streak = 0
    start_position = -1
    max_seq_len = 0
    best_start = -1

    for num in range(l, r + 1):
        if is_odd_powered(num):
            current_streak += 1
            if current_streak >= m:
                best_start = num - m + 1
                break
        else:
            current_streak = 0

    if best_start != -1:
        return list(range(best_start, best_start + m))
    else:
        return [-1]


# Чтение входных данных
m = int(input())
l, r = map(int, input().split())

# Нахождение последовательности
sequence = find_sequence(l, r, m)

# Вывод результата
if sequence[0] == -1:
    print(-1)
else:
    print(" ".join(map(str, sequence)))