def count_cells(n, m, k):
    # Результат: количество клеток каждого цвета
    result = [0] * k

    # Перебираем все возможные суммы координат s
    for s in range(1, n + m):
        # Количество клеток с данной суммой координат
        cells_in_diagonal = min(s, n, m, s - m + 1, n + m - s)

        # Циклом распределяем клетки по цветам
        color_id = (s - 1) % k
        result[color_id] += cells_in_diagonal

    return result


# Чтение входных данных
n = int(input())
m = int(input())
k = int(input())


# Выполнение расчётов
colors_counts = count_cells(n, m, k)

# Вывод результата
for count in colors_counts:
    print(count)