def count_cells(n, m, k):
    # Массив для хранения количества клеток каждого цвета
    colors_count = [0] * k

    for i in range(1, n + 1):  # Обходим строки
        for j in range(1, m + 1):  # Обходим столбцы
            d = i + j - 1  # Номер диагонали
            color_idx = ((d - 1) % k) % k  # Индекс цвета (от 0 до k-1)
            colors_count[color_idx] += 1  # Увеличим счётчик клеток текущего цвета

    return colors_count


# Входные данные
n, m, k = map(int, input().split())  # Читаем размер матрицы и количество цветов

result = count_cells(n, m, k)
for cnt in result:
    print(cnt)