def can_form_cube(numbers):
    total_sum = sum(numbers)
    if total_sum % 3 != 0:
        return False

    target_sum = total_sum // 3

    numbers.sort()
    i = 0
    j = len(numbers) - 1

    while i < j:
        current_sum = numbers[i] + numbers[j]

        if current_sum == target_sum:
            del numbers[i]
            del numbers[j-1]

            j -= 2
        elif current_sum > target_sum:
            j -= 1
        else:
            i += 1

    return len(numbers) == 0

if __name__ == "__main__":
    import sys
    input = sys.stdin.read
    data = input().strip().split('\n')

    n = int(data[0])
    results = []

    for line in data[1:]:
        numbers = list(map(int, line.split()))
        if can_form_cube(numbers[:]):
            results.append("yes")
        else:
            results.append("no")

    print("\n".join(results))