#include <bits/stdc++.h>

using namespace std;
using ll = long long;

const ll N = 1e5 + 10;
const ll LOG = 31;
const ll MOD = 1e9 + 9;
const ll INF = 1e18;

struct edge_up {
    int start, end;
    bool flag;
};

edge_up tree_up[4 * N];
edge_up tree_down[4 * N];
int a[N];

void build(int v, int tl, int tr) {
    if (tl == tr) {
        tree_up[v] = {a[tl], a[tl], true};
        tree_down[v] = {a[tl], a[tl], true};
        return;
    }

    int tm = (tl + tr) / 2;

    build(2 * v, tl, tm);
    build(2 * v + 1, tm + 1, tr);

    tree_up[v].flag = false;

    if (tree_up[2 * v].flag && tree_up[2 * v + 1].flag && tree_up[2 * v + 1].start == tree_up[2 * v].end + 1) {
        tree_up[v].flag = true;
    }

    tree_up[v].start = tree_up[2 * v].start;
    tree_up[v].end = tree_up[2 * v + 1].end;

    //

    tree_down[v].flag = false;

    if (tree_down[2 * v].flag && tree_down[2 * v + 1].flag && tree_down[2 * v + 1].start == tree_down[2 * v].end - 1) {
        tree_down[v].flag = true;
    }

    tree_down[v].start = tree_down[2 * v].start;
    tree_down[v].end = tree_down[2 * v + 1].end;
}

void rev(int v, int tl, int tr, int pos, int val) {
    if (tl == tr) {
        tree_up[v] = {val, val, true};
        tree_down[v] = {val, val, true};
        return;
    }

    int tm = (tl + tr) / 2;

    if (pos <= tm) {
        rev(2 * v, tl, tm, pos, val);
    } else {
        rev(2 * v + 1, tm + 1, tr, pos, val);
    }

    tree_up[v].flag = false;

    if (tree_up[2 * v].flag && tree_up[2 * v + 1].flag && tree_up[2 * v + 1].start == tree_up[2 * v].end + 1) {
        tree_up[v].flag = true;
    }

    tree_up[v].start = tree_up[2 * v].start;
    tree_up[v].end = tree_up[2 * v + 1].end;

    //

    tree_down[v].flag = false;

    if (tree_down[2 * v].flag && tree_down[2 * v + 1].flag && tree_down[2 * v + 1].start == tree_down[2 * v].end - 1) {
        tree_down[v].flag = true;
    }

    tree_down[v].start = tree_down[2 * v].start;
    tree_down[v].end = tree_down[2 * v + 1].end;
}

edge_up get_up(int v, int tl, int tr, int l, int r) {
    if (l <= tl && tr <= r) {
        return tree_up[v];
    }

    if (l > tr || r < tl) {
        return {-1, -1, false};
    }

    int tm = (tl + tr) / 2;

    edge_up e1 = get_up(2 * v, tl, tm, l, r);
    edge_up e2 = get_up(2 * v + 1, tm + 1, tr, l, r);

    if (e1.start == -1 && e1.end == -1 && e1.flag == false) {
        return e2;
    } else if (e2.start == -1 && e2.end == -1 && e2.flag == false) {
        return e1;
    } else {
        edge_up e;

        e.flag = false;

        if (e1.flag && e2.flag && e2.start == e1.end + 1) {
            e.flag = true;
        }

        e.start = e1.start;
        e.end = e2.end;

        return e;
    }
}

edge_up get_down(int v, int tl, int tr, int l, int r) {
    if (l <= tl && tr <= r) {
        return tree_down[v];
    }

    if (l > tr || r < tl) {
        return {-1, -1, false};
    }

    int tm = (tl + tr) / 2;

    edge_up e1 = get_down(2 * v, tl, tm, l, r);
    edge_up e2 = get_down(2 * v + 1, tm + 1, tr, l, r);

    if (e1.start == -1 && e1.end == -1 && e1.flag == false) {
        return e2;
    } else if (e2.start == -1 && e2.end == -1 && e2.flag == false) {
        return e1;
    } else {
        edge_up e;

        e.flag = false;

        if (e1.flag && e2.flag && e2.start == e1.end - 1) {
            e.flag = true;
        }

        e.start = e1.start;
        e.end = e2.end;

        return e;
    }
}

int n;

int dd_up(int v, int tl, int tr) {
    if (tl == tr) {
        return tl;
    }

    int tm = (tl + tr) / 2;

    if (tree_up[2 * v].flag && tree_up[2 * v + 1].start == tree_up[2 * v].end + 1 && tm < n) {
        return dd_up(2 * v + 1, tm + 1, tr);
    }

    return dd_up(2 * v, tl, tm);
}

int dd_up2(int v, int tl, int tr) {
    if (tl == tr) {
        return tl;
    }

    int tm = (tl + tr) / 2;

    if (tree_up[2 * v + 1].flag && tree_up[2 * v + 1].start == tree_up[2 * v].end + 1 && tm < n) {
        return dd_up2(2 * v, tl, tm);
    }

    return dd_up2(2 * v + 1, tm + 1, tr);
}

int dd_down(int v, int tl, int tr) {
    if (tl == tr) {
        return tl;
    }

    int tm = (tl + tr) / 2;

    if (tree_down[2 * v].flag && tree_down[2 * v + 1].start == tree_down[2 * v].end - 1 && tm < n) {
        return dd_down(2 * v + 1, tm + 1, tr);
    }

    return dd_down(2 * v, tl, tm);
}

int spusk_up_right(int v, int tl, int tr, int l, int r) {
    if (l <= tl && tr <= r) {
        if (tree_up[v].flag) {
            return tr;
        }

        return dd_up(v, tl, tr);
    }

    if (l > tr || r < tl) {
        return -1;
    }

    int tm = (tl + tr) / 2;

    int res1 = spusk_up_right(2 * v, tl, tm, l, r);

    if (res1 == -1 || (tm < n && res1 == tm && a[tm + 1] == a[tm] + 1)) {
        return spusk_up_right(2 * v + 1, tm + 1, tr, l, r);
    }

    return res1;
}

int spusk_up_left(int v, int tl, int tr, int l, int r) {
    if (l <= tl && tr <= r) {

        if (tree_up[v].flag) {
            return tl;
        }

        return dd_up2(v, tl, tr);
    }

    if (l > tr || r < tl) {
        return -1;
    }

    int tm = (tl + tr) / 2;

    int res2 = spusk_up_left(2 * v + 1, tm + 1, tr, l, r);

    if (res2 == -1 || (tm < n && res2 == tm + 1 && a[tm] + 1 == a[tm + 1])) {
        return spusk_up_left(2 * v, tl, tm, l, r);
    }

    return res2;
}

int spusk_down_right(int v, int tl, int tr, int l, int r) {
    if (l <= tl && tr <= r) {
        if (tree_down[v].flag) {
            return tr;
        }

        return dd_down(v, tl, tr);
    }

    if (l > tr || r < tl) {
        return -1;
    }

    int tm = (tl + tr) / 2;

    int res1 = spusk_down_right(2 * v, tl, tm, l, r);

    if (res1 == -1 || (tm < n && res1 == tm && a[tm + 1] == a[tm] - 1)) {
        return spusk_down_right(2 * v + 1, tm + 1, tr, l, r);
    }

    return res1;
}


int find_leftest(int i) {
    return spusk_up_left(1, 1, n, 1, i);
}

int find_rightest(int i) {
    return spusk_down_right(1, 1, n, i, n);
}

int find_rg_right(int i) {
    return spusk_up_right(1, 1, n, i, n);
}

int find_rg_left(int i) {
    int l = 0;
    int r = i;

    while (r - l > 1) {
        int mid = (l + r) / 2;

        if (get_down(1, 1, n, mid, i).flag) {
            r = mid;
        } else {
            l = mid;
        }
    }

    return r;
}

void solve() {
    cin >> n;

    for (int i = 1; i <= n; i++) {
        cin >> a[i];
    }

    build(1, 1, n);

    multiset<int> st;

    for (int i = 1; i <= n; i++) {
        st.insert(min(i - find_leftest(i), find_rightest(i) - i) * 2 + 1);
    }

    auto ii = st.end();
    ii--;

    cout << *ii << '\n';

    int q;
    cin >> q;

    while (q--) {
        int i, x;
        cin >> i >> x;

        if (a[i] == x) {
            auto it = st.end();
            it--;

            cout << *it << '\n';

            continue;
        }

        st.erase(st.find(min(i - find_leftest(i), find_rightest(i) - i) * 2 + 1));
        int rg = find_rg_right(i);
        int lg = find_rg_left(i);

        // check for rg

        if (rg != i) {
            int tt = find_rightest(rg);
            int tt2 = find_leftest(rg);

            st.erase(st.find(min(tt - rg, rg - tt2) * 2 + 1));
            st.insert(min(rg - (i + 1), tt - rg) * 2 + 1);
        }

        if (lg != i) {
            int tt = find_rightest(lg);
            int tt2 = find_leftest(lg);

            st.erase(st.find(min(tt - lg, lg - tt2) * 2 + 1));
            st.insert(min(lg - tt2, i - 1 - lg) * 2 + 1);
        }

        rev(1, 1, n, i, x);
        a[i] = x;

        st.insert(min(find_rightest(i) - i, i - find_leftest(i)) * 2 + 1);

        rg = find_rg_right(i);
        lg = find_rg_left(i);

        // check for rg

        if (rg != i) {
            int tt = find_rightest(rg);
            int tt2 = find_leftest(rg);

            st.erase(st.find(min(rg - (i + 1), tt - rg) * 2 + 1));
            st.insert(min(tt - rg, rg - tt2) * 2 + 1);
        }

        if (lg != i) {
            int tt = find_rightest(lg);
            int tt2 = find_leftest(lg);

            st.erase(st.find(min(lg - tt2, i - 1 - lg) * 2 + 1));
            st.insert(min(tt - lg, lg - tt2) * 2 + 1);
        }


        auto it = st.end();
        it--;

        cout << *it << '\n';
    }
}


signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    int tt = 1;
    // cin >> tt;
    while (tt--) {
        solve();
    }
}


