#include <bits/stdc++.h>
//#include <ext/pb_ds/assoc_container.hpp>
#define pb push_back
#define eb emplace_back
#define asc(x) x.begin(), x.end()
#define des(x) x.rbegin(), x.rend()
#define ll long long
#define ld long double

using namespace std;

mt19937 gen(239);

//using namespace __gnu_pbds;
//using ordered_set = tree<int, null_type, less<int>, rb_tree_tag, tree_order_statistics_node_update>;

const ll INF = 1e18, inf = 1e18, MOD = 1e9 + 7;

struct smt {
    vector<int> pref;

    void init(int n) {
        pref.assign(n + 10, 0);
    }

    void update(int ql, int val) {
        ++ql;

        for (int i = ql; i < pref.size(); i += (i & -i)) {
            pref[i] += val;
        }
    }

    int query(int ql) {
        int ans = 0;

        for (int i = ql; i > 0; i -= (i & -i)) {
            ans += pref[i];
        }

        return ans;
    }

    int query(int l, int r) {
        return query(r + 1) - query(l);
    }
};

struct seg_tree {
    vector<pair<int, int>> tree;
    vector<int> a;

    int merge(int s1, int s2, int i1, int i2) {
        if (s1 + i1 < s2) return i1;

        if (a[s2 - 1] - 1 != a[s2]) return i1;

        return i1 + i2;
    }

    int merge_(int s1, int s2, int i1, int i2) {
        if (s1 + i1 < s2) return i1;

        if (a[s2 - 1] + 1 != a[s2]) return i1;

        return i1 + i2;
    }

    void init(int n, int l, int r) {
        if (r - l == 1) {
            tree[n] = {1, 1};
            return;
        }

        int m = (l + r) / 2;
        init(2 * n + 1, l, m);
        init(2 * n + 2, m, r);

        tree[n].first = merge(l, m, tree[2 * n + 1].first, tree[2 * n + 2].first);
        tree[n].second = merge_(l, m, tree[2 * n + 1].second, tree[2 * n + 2].second);
    }

    void update(int n, int l, int r, int ql, int val) {
        if (ql >= r || l > ql) return;
        if (r - l == 1) return;

        int m = (l + r) / 2;
        update(2 * n + 1, l, m, ql, val);
        update(2 * n + 2, m, r, ql, val);

        tree[n].first = merge(l, m, tree[2 * n + 1].first, tree[2 * n + 2].first);
        tree[n].second = merge_(l, m, tree[2 * n + 1].second, tree[2 * n + 2].second);
    }

    pair<int, int> bin(int n, int l, int r, int ql, int qr) {
        if (ql >= r || l >= qr) return {0, 0};
        if (ql <= l && r <= qr) return tree[n];

        int m = (l + r) / 2;

        auto i1 = bin(2 * n + 1, l, m, ql, qr);
        auto i2 = bin(2 * n + 2, m, r, ql, qr);

        if (m <= ql) {
            return i2;
        }

        int x = merge(max(ql, l), m, i1.first, i2.first);
        int y = merge_(max(ql, l), m, i1.second, i2.second);

        return {x, y};
    }
};

int n;

seg_tree tree1, tree2;

pair<int, int> left(int i) {
    int j = n - i - 1;

    auto vl = tree2.bin(0, 0, n, j, n);

    return vl;
}

pair<int, int> right(int i) {
    return tree1.bin(0, 0, n, i, n);
}

int get(int i) {
    int vl = left(i).first;

    int vr = right(i).first;

    return min(vl, vr) * 2 - 1;
}

vector<int> ar;

void solve() {
    cin >> n;

    ar.resize(n);
    set<int> s;

    for (int i = 0; i < n; ++i) cin >> ar[i];

    for (int i = 1; i + 1 < n; ++i) {
        if (ar[i] - 1 == ar[i - 1] && ar[i] - 1 == ar[i + 1]) {
            s.insert(i);
        }
    }

    tree1.a = ar; tree1.tree.assign(4 * n, {0, 0});
    tree2.a = ar; tree2.tree.assign(4 * n, {0, 0});

    reverse(asc(tree2.a));

    tree1.init(0, 0, n);
    tree2.init(0, 0, n);

    map<int, int> ans;
    for (int i : s) {
        ans[get(i)]++;
    }

    if (ans.empty()) {
        cout << "1\n";
    } else {
        cout << ans.rbegin()->first << "\n";
    }

    auto remove = [&](int x) {
        if (s.find(x) == s.end()) return;

        s.erase(x);
        int val = get(x);

        ans[val]--;

        if (!ans[val]) ans.erase(val);
    };

    auto add = [&](int x) {
        if (!x || x + 1 == n) return;

        if (ar[x - 1] + 1 != ar[x] || ar[x + 1] + 1 != ar[x]) return;

        s.insert(x);
        int val = get(x);

        ans[val]++;
    };

    int q; cin >> q;
    while (q--) {
        int i, x; cin >> i >> x; --i;

        remove(i);

        int vl = left(i).second, vr = right(i).second;

        remove(i - vl + 1);
        remove(i + vr - 1);

        int j = n - i - 1;

        tree1.a[i] = x;
        tree2.a[j] = x;

        ar[i] = x;

        tree1.update(0, 0, n, i, x);
        tree2.update(0, 0, n, j, x);

        add(i);

        vl = left(i).second, vr = right(i).second;

        add(i - vl + 1);
        add(i + vr - 1);

        if (ans.empty()) {
            cout << "1\n";
        } else {
            cout << ans.rbegin()->first << "\n";
        }
    }
}

signed main() {
    ios_base::sync_with_stdio(0), cin.tie(0), cout.tie(0);
    int tt = 1;
    while (tt--) {
        solve();
        cout << "\n";
    }
}